/* Copyright (C) 2005-2013, Unigine Corp. All rights reserved.
 *
 * File:    heaven-ui-logic.js
 * Version: 1.02
 * Authors: Evgeniy Tetenchuk <johnatan@unigine.com>
 *          Denis Shergin <binstrem@unigine.com>
 *
 * This file is part of the Unigine engine (http://unigine.com/).
 *
 * Your use and or redistribution of this software in source and / or
 * binary form, with or without modification, is subject to: (i) your
 * ongoing acceptance of and compliance with the terms and conditions of
 * the Unigine License Agreement; and (ii) your inclusion of this notice
 * in any version of this software that you use or redistribute.
 * A copy of the Unigine License Agreement is available by contacting
 * Unigine Corp. at http://unigine.com/
 */

EngineTranslator.setup({
	'en': {
		'name': 'English',
		'keys': {
			'label_language': {'html': 'Language:'},
			'label_preset': {'html': 'Preset:'},
			'label_video_app': {'html': 'API:'},
			'label_video_fullscreen': {'html': 'Full Screen:', 'css': {'margin': '0 5px 0 0'}},
			'label_video_mode': {'html': 'Resolution:'},
			'label_heaven_quality': {'html': 'Quality:'},
			'label_stereo': {'html': 'Stereo 3D:'},
			'label_muiltimonitor': {'html': 'Multi-monitor:'},
			'label_video_multisample': {'html': 'Anti-aliasing:'},
			'label_shaders': {'html': 'Tessellation:'},
			'get-other-button': {'html': 'Get more Unigine products'},
			'update-button': {'html': 'Upgrade to Advanced edition'},
			'custom_width': {'attr': {'title': 'Values can be set from 128 to 4096'}},
			'custom_height': {'attr': {'title': 'Values can be set from 128 to 4096'}},
			'invalid_field': 'Invalid %field_name%! Try setting another pair of values.',

			'preset_custom': {'html': 'Custom'},
			'preset_basic': {'html': 'Basic'},
			'preset_extreme': {'html': 'Extreme'},

			'heaven_quality_QUALITY_LOW': {'html': 'Low'},
			'heaven_quality_QUALITY_MEDIUM': {'html': 'Medium'},
			'heaven_quality_QUALITY_HIGH': {'html': 'High'},
			'heaven_quality_QUALITY_ULTRA': {'html': 'Ultra'},

			'shaders_disabled': {'html': 'Disabled'},
			'shaders_tessellation_type_MODERATE': {'html': 'Moderate'},
			'shaders_tessellation_type_NORMAL': {'html': 'Normal'},
			'shaders_tessellation_type_EXTREME': {'html': 'Extreme'},

			'stereo_-1': {'html': 'Disabled'},
			'stereo_STEREO_3D_VISION': {'html': '3DVision'},
			'stereo_STEREO_3D_SURROUND': {'html': '3DSurround'},
			'stereo_STEREO_SEPARATE': {'html': 'Dual Output'},
			'stereo_STEREO_HORIZONTAL': {'html': 'Side-by-side'},
			'stereo_STEREO_VERTICAL': {'html': 'Top-and-bottom'},
			'stereo_STEREO_INTERLACED': {'html': 'Interlaced'},
			'stereo_STEREO_ANAGLYPH': {'html': 'Anaglyph'},

			'muiltimonitor_disabled': {'html': 'Disabled'},
			'muiltimonitor_SURROUND': {'html': 'Surround 3x1'},
			'muiltimonitor_WALL_AUTO': {'html': 'Wall Auto'},
			'muiltimonitor_WALL_21': {'html': 'Wall 2x1'},
			'muiltimonitor_WALL_12': {'html': 'Wall 1x2'},
			'muiltimonitor_WALL_22': {'html': 'Wall 2x2'},
			'muiltimonitor_WALL_31': {'html': 'Wall 3x1'},
			'muiltimonitor_WALL_32': {'html': 'Wall 3x2'},
			'muiltimonitor_WALL_41': {'html': 'Wall 4x1'},
			'muiltimonitor_WALL_51': {'html': 'Wall 5x1'},

			'video_multisample_0': {'html': 'Off'},

			'video_mode_-1': {'html': 'System'},
			'video_mode_custom': {'html': 'Custom'}
		}
	},
	'ru': {
		'name': 'Русский',
		'keys': {
			'label_language': {'html': 'Язык:'},
			'label_preset': {'html': 'Профиль:'},
			'label_video_app': {'html': 'API:'},
			'label_video_fullscreen': {'html': 'Полный экран:', 'css': {'margin': '0 -1px 0 -4px'}},
			'label_video_mode': {'html': 'Разрешение:'},
			'label_heaven_quality': {'html': 'Качество:'},
			'label_stereo': {'html': 'Стерео 3D:'},
			'label_muiltimonitor': {'html': 'Матрица:'},
			'label_video_multisample': {'html': 'AA:'},
			'label_shaders': {'html': 'Тесселяция:'},
			'get-other-button': {'html': 'Другие продукты от Unigine'},
			'update-button': {'html': 'Купить Advanced версию'},
			'custom_width': {'attr': {'title': 'Укажите значение от 128 до 4096'}},
			'custom_height': {'attr': {'title': 'Укажите значение от 128 до 4096'}},
			'invalid_field': 'Указанное %field_name% не поддерживается.',

			'preset_custom': {'html': 'Свой'},
			'preset_basic': {'html': 'Базовый'},
			'preset_extreme': {'html': 'Экстрим'},

			'heaven_quality_QUALITY_LOW': {'html': 'Низкое'},
			'heaven_quality_QUALITY_MEDIUM': {'html': 'Среднее'},
			'heaven_quality_QUALITY_HIGH': {'html': 'Высокое'},
			'heaven_quality_QUALITY_ULTRA': {'html': 'Ультра'},

			'shaders_disabled': {'html': 'Нет'},
			'shaders_tessellation_type_MODERATE': {'html': 'Умеренная'},
			'shaders_tessellation_type_NORMAL': {'html': 'Стандартная'},
			'shaders_tessellation_type_EXTREME': {'html': 'Экстрим'},

			'stereo_-1': {'html': 'Выключено'},
			'stereo_STEREO_3D_VISION': {'html': '3DVision'},
			'stereo_STEREO_3D_SURROUND': {'html': '3DSurround'},
			'stereo_STEREO_SEPARATE': {'html': 'Dual Output'},
			'stereo_STEREO_HORIZONTAL': {'html': 'Side-by-side'},
			'stereo_STEREO_VERTICAL': {'html': 'Top-and-bottom'},
			'stereo_STEREO_INTERLACED': {'html': 'Interlaced'},
			'stereo_STEREO_ANAGLYPH': {'html': 'Anaglyph'},

			'muiltimonitor_disabled': {'html': 'Выключить'},
			'muiltimonitor_SURROUND': {'html': 'Surround 3x1'},
			'muiltimonitor_WALL_AUTO': {'html': 'Автовыбор'},
			'muiltimonitor_WALL_21': {'html': '2x1 монитора'},
			'muiltimonitor_WALL_12': {'html': '1x2 монитора'},
			'muiltimonitor_WALL_22': {'html': '2x2 монитора'},
			'muiltimonitor_WALL_31': {'html': '3x1 монитора'},
			'muiltimonitor_WALL_32': {'html': '3x2 монитора'},
			'muiltimonitor_WALL_41': {'html': '4x1 монитора'},
			'muiltimonitor_WALL_51': {'html': '5x1 монитора'},

			'video_multisample_0': {'html': 'Нет'},

			'video_mode_-1': {'html': 'Системное'},
			'video_mode_custom': {'html': 'Свое'}
		}
	},
	'ch': {
		'name': '中文',
		'keys': {
			'label_language': {'html': '语言:'},
			'label_preset': {'html': '预置'},
			'label_video_app': {'html': 'API:'},
			'label_video_fullscreen': {'html': '全屏:', 'css': {'margin': '0 5px 0 0'}},
			'label_video_mode': {'html': '分辨率:'},
			'label_heaven_quality': {'html': '质量:'},
			'label_stereo': {'html': '3D立体声:'},
			'label_muiltimonitor': {'html': '多显示器:'},
			'label_video_multisample': {'html': '反锯齿处理:'},
			'label_shaders': {'html': '曲面细分:'},
			'get-other-button': {'html': '其它Unigine产品'},
			'update-button': {'html': '升级到专业版'},
			'custom_width': {'attr': {'title': '数值的设置范围是128到4096'}},
			'custom_height': {'attr': {'title': '数值的设置范围是128到4096'}},
			'invalid_field': '%field_name%无效！尝试设置另一对数值。',

			'preset_custom': {'html': '自定义'},
			'preset_basic': {'html': '基本'},
			'preset_extreme': {'html': '极端'},

			'heaven_quality_QUALITY_LOW': {'html': '低'},
			'heaven_quality_QUALITY_MEDIUM': {'html': '中'},
			'heaven_quality_QUALITY_HIGH': {'html': '高'},
			'heaven_quality_QUALITY_ULTRA': {'html': '超'},

			'shaders_disabled': {'html': '被禁用'},
			'shaders_tessellation_type_MODERATE': {'html': '中度'},
			'shaders_tessellation_type_NORMAL': {'html': '正常'},
			'shaders_tessellation_type_EXTREME': {'html': '极端'},

			'stereo_-1': {'html': '被禁用'},
			'stereo_STEREO_3D_VISION': {'html': '3DVision'},
			'stereo_STEREO_3D_SURROUND': {'html': '3DSurround'},
			'stereo_STEREO_SEPARATE': {'html': 'Dual Output'},
			'stereo_STEREO_HORIZONTAL': {'html': 'Side-by-side'},
			'stereo_STEREO_VERTICAL': {'html': 'Top-and-bottom'},
			'stereo_STEREO_INTERLACED': {'html': 'Interlaced'},
			'stereo_STEREO_ANAGLYPH': {'html': 'Anaglyph'},

			'muiltimonitor_disabled': {'html': '被禁用'},
			'muiltimonitor_SURROUND': {'html': 'Surround 3x1'},
			'muiltimonitor_WALL_AUTO': {'html': 'Wall Auto'},
			'muiltimonitor_WALL_21': {'html': 'Wall 2x1'},
			'muiltimonitor_WALL_12': {'html': 'Wall 1x2'},
			'muiltimonitor_WALL_22': {'html': 'Wall 2x2'},
			'muiltimonitor_WALL_31': {'html': 'Wall 3x1'},
			'muiltimonitor_WALL_32': {'html': 'Wall 3x2'},
			'muiltimonitor_WALL_41': {'html': 'Wall 4x1'},
			'muiltimonitor_WALL_51': {'html': 'Wall 5x1'},

			'video_multisample_0': {'html': '关闭'},

			'video_mode_-1': {'html': '被禁用'},
			'video_mode_custom': {'html': '自定义'}
		}
	}
});

var form = window.formOverrive || [
	SimpleCommandLine('project_name', OptionsBuilder.getOptions()['project_name']),
	SimpleCommandLine('data_path', '../'),
	SimpleCommandLine('engine_config', '../data/heaven_4.0.cfg'),
	SimpleCommandLine('system_script', 'heaven/unigine.cpp'),
	SimpleCommandLine('sound_app', 'openal'),
	SimpleExternDefine('release_extern_define', 'RELEASE'),
	SimpleExternDefine('pro_extern_define', 'HEAVEN_PRO', ['pro']),
	SimpleExternDefine('advanced_extern_define', 'HEAVEN_ADV', ['advanced']),
	SimpleExternPlugin('GPUMonitorPlugin', 'GPUMonitor'),
	{
		'element': TranslatorWidget(),
		'label': 'Language'
	},
	{
		'element': Preset(),
		'label': 'Preset'
	},
	{
		'element': Video_app(),
		'label': 'API'
	},
	{
		'element': HeavenQuality(),
		'label': 'Quality'
	},
	{
		'element': Tessellation(),
		'label': 'Tessellation'
	},
	{
		'element': Stereo(),
		'label': 'Stereo 3D'
	},
	{
		'element': MultiMonitor(),
		'label': 'Multi-monitor'
	},
	{
		'element': Multisample(),
		'label': 'Anti-aliasing'
	},
	{
		'element': Fullscreen(),
		'label': 'Full Screen'
	},
	{
		'element': Resolution(),
		'label': 'Resolution'
	}
];

OptionsBuilder.build(form, '#run_params');

function startBenchmark() {
	var $this = $(this);

	if ($this.is(':animated')) {
		return;
	}

	$this.unbind('click', startBenchmark);

	$this
		.attr('disabled', 'disabled')
		.css({'opacity': .5, 'cursor': 'auto'})
		.removeClass('enabled');

	$this.animate({'opacity': 1}, 5000, function() {
		$this
			.removeAttr('disabled')
			.css({'cursor': 'pointer'})
			.click(startBenchmark)
			.addClass('enabled');
	});

	EngineLauncher.launch(OptionsBuilder.getCommandLine());
}

$(function() {
	$('select').selectmenu({
		style: 'dropdown',
		width: 105
	});

	BannerEngine.start({
		'productName': OptionsBuilder.getOptions()['project_name'],
		'productVersion': '4.0',
		'updateUrl': 'http://unigine.com/update/'
	});

	Defines.start();

	$('#run').click(startBenchmark);
	
	EngineTranslator.setTranslationCallback(function(lang) {
		$('select').selectmenu();
	});
});
