/* bannerOilRush
 */
function bannerOilRush() {
	/*
	fields
	 */
	this.button_speed = 1500;
	this.logo_speed = 700;
	this.page_dellay = 3000;
	this.container = null;
	this.is_stoped = false;

	/*
	 */
	this.init = function ($container) {
		var self = this;
		self.container = $container;
		self._prepare();
		self.is_stoped = false;
	};

	/*
	*/
	this.shutdown = function () {
		var self = this;
		self._prepare();
		self.container = null;
		self.is_stoped = true;
	};

	/*
	*/
	this.play = function () {
		var self = this;
		self._prepare();
		self._animate_button_paly();
		self._animate_button_watch();
		self._animate_logo_game();
	};

	/*
	 */
	this._prepare = function () {
		var self = this;
		$('.banner-button-play', self.container)
				.stop(true, false)
				.css('bottom', '-66px');

		$('.banner-button-watch', self.container)
				.stop(true, false)
				.css('top', '-50px');

		$(".banner-logo-game", self.container)
			.stop(true, false)
			.css('top', '-109px')
			.css('opacity', '0');

		$(".banner-logo-unigine", self.container)
			.stop(true, false)
			.css('top', '-27px')
			.css('opacity', '0');
	}

	/*
	 */
	this._animate_button_paly = function () {
		var self = this;
		if (self.is_stoped) {
			self._prepare();
			return; 
		}
		$('.banner-button-play', self.container)
			.animate({ bottom: 0 }, self.button_speed, "easeInOutBounce");
	};

	/*
	 */
	this._animate_button_watch = function () {
		var self = this;
		if (self.is_stoped) {
			self._prepare();
			return; 
		}
		$('.banner-button-watch', self.container)
			.animate({ top: 0 }, self.button_speed, "easeInOutBounce",function(){ if (self.is_stoped) { self._prepare(); }});
	};

	/*
	 */
	this._animate_logo_game = function () {
		var self = this;
		$(".banner-logo-game", self.container)
			.animate({ top: -53, opacity: 1 }, self.logo_speed, "linear",function(){ if (self.is_stoped) { self._prepare() }})
			.delay(self.page_dellay)
			.animate({ top: -5, opacity: 0.5 }, self.logo_speed * 0.5, "linear",function() { 
				if (self.is_stoped) { 
					self._prepare();
					return; 
				} 
				self._animate_logo_unigine();
			})
			.animate({ top: 46, opacity: 0 }, self.logo_speed * 0.5, "linear")
			.animate({ top: -96, opacity: 0 }, self.page_dellay + self.logo_speed * 0.5, "linear", function() { 
				if (self.is_stoped) { 
					self._prepare();
					return; 
				}
				self._animate_logo_game() 
			});
	};

	/*
	 */
	this._animate_logo_unigine = function () {
		var self = this;
		$(".banner-logo-unigine", self.container)
			.animate({ top: 7, opacity: 1 }, self.logo_speed, "linear",function(){ if (self.is_stoped) { self._prepare(); }})
			.delay(self.page_dellay)
			.animate({ top: 80, opacity: 0 }, self.logo_speed, "linear",function(){ if (self.is_stoped) { self._prepare(); }})
			.animate({ top: -27, opacity: 0 }, 100, "linear");
	};
}

// create object
new bannerOilRush();
