/*
 * Decompiled with CFR 0.152.
 */
package org.polymc.applet;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.Launcher;

public final class LegacyFrame
extends Frame {
    private static final Logger LOGGER = Logger.getLogger("LegacyFrame");
    private final Launcher appletWrap;

    public LegacyFrame(String string, Applet applet) {
        super(string);
        this.appletWrap = new Launcher(applet);
        applet.setStub(this.appletWrap);
        try {
            this.setIconImage(ImageIO.read(new File("icon.png")));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Unable to read Minecraft icon!", iOException);
        }
        this.addWindowListener(new ForceExitHandler());
    }

    public void start(String string, String string2, int n, int n2, boolean bl, String string3, String string4, boolean bl2) {
        Path path = Paths.get(System.getProperty("user.dir"), "..", "mpticket");
        Path path2 = Paths.get(System.getProperty("user.dir"), "..", "mpticket.corrupt");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> list = Files.readAllLines(path, StandardCharsets.UTF_8);
                if (list.size() < 3) {
                    Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.warning("Mpticket file is corrupted!");
                } else {
                    this.appletWrap.setParameter("server", list.get(0));
                    this.appletWrap.setParameter("port", list.get(1));
                    this.appletWrap.setParameter("mppass", list.get(2));
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Unable to read mpticket file!", iOException);
            }
        }
        if (string3 != null) {
            this.appletWrap.setParameter("server", string3);
            this.appletWrap.setParameter("port", string4);
        }
        this.appletWrap.setParameter("username", string);
        this.appletWrap.setParameter("sessionid", string2);
        this.appletWrap.setParameter("stand-alone", "true");
        this.appletWrap.setParameter("haspaid", "true");
        this.appletWrap.setParameter("demo", bl2 ? "true" : "false");
        this.appletWrap.setParameter("fullscreen", "false");
        this.add(this.appletWrap);
        this.appletWrap.setPreferredSize(new Dimension(n, n2));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        if (bl) {
            this.setExtendedState(6);
        }
        this.validate();
        this.appletWrap.init();
        this.appletWrap.start();
        this.setVisible(true);
    }

    private final class ForceExitHandler
    extends WindowAdapter {
        private ForceExitHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    LOGGER.info("Forcing exit!");
                    System.exit(0);
                }
            }).start();
            if (LegacyFrame.this.appletWrap != null) {
                LegacyFrame.this.appletWrap.stop();
                LegacyFrame.this.appletWrap.destroy();
            }
            System.exit(0);
        }
    }
}

